<?php
  include 'constants.php';
  spl_autoload_register('classLoader');
  session_start();

  try{
    $portal = new PortalAdmin("localhost", "php", "test", "testphp");

    //Sprawdzenie czy jest parametr action
    if (isset($_GET['action'])) {
      $action = $_GET['action'];
    }
    else{
      $action = 'showMainAdmin';
    }

    //Odczytanie komunikatu, jeśli został przekazany
    $komunikat_adm = $portal->getAdminMessage();

    //Wykonanie procedury logowania lub wylogowania
    switch($action){
      case 'login':
        if(!$portal->zalogowany_adm)
        switch($portal->login()){
          case LOGIN_OK:
            $portal->setAdminMessage("Zalogowanie prawidłowe");
            break;
          case LOGIN_FAILED:
            $portal->setAdminMessage("Nieprawidłowa nazwa lub hasło!");
            break;
          case NO_ADMIN_RIGHTS:
            $portal->setAdminMessage("Brak uprawnień administracyjnych!");
            $portal->logout();
            break;
          case SERVER_ERROR:
          default:
            $portal->setAdminMessage("Błąd serwera!");
            $portal->logout();
        }
        header('Location:index.php');
        exit();
      case 'logout':
        $portal->logout();
        header('Location:index.php');
        exit();
      case 'subscriptionsAdmin':
        if(isset($_GET['wtd']) && $_GET['wtd'] == 'getEmailsList'){
          $portal->subscriptionsAdmin();
          return;
        }
        break;
    }

    //Ustalenie akcji dla niezalogowanego użytkownika
    if(!$portal->zalogowany_adm){
      $action = 'showLoginForm';
    }
    include 'templates/mainTemplate.php';
  }
  catch(Exception $e){
    exit('Panel administracyjny jest niedostępny.');
  }
  
  function classLoader($nazwa){
    if(file_exists("../klasy/$nazwa.php")){
      require_once("../klasy/$nazwa.php");
    } else {
      throw new Exception("Brak pliku z definicją klasy.");
    }
  }  
?>